@echo off
if %ERRORLEVEL% neq 0 (
   call vidWrongcp.bat
   exit /b 0
)
chcp 65001>NUL
set "arxiki=%cd%"
setlocal EnableDelayedExpansion && cd /D "%~dp0"

rem Automatic multi-level multi-option menu system
rem Antonio Perez Ayala - 2022/02/09
rem         version 1.2 - 2022/02/12
rem https://www.dostips.com/forum/viewtopic.php?f=3&t=10377
rem
rem if "%~1" neq "" if "%~1" neq "/?" goto begin
rem echo Activate a multi-level multi-option menu system
rem echo/
rem echo    %~NX0 menuFolder
rem echo/
rem echo The menu is defined into menuFolder via subfolders, .txt and .bat files.
rem echo The names of these elements must have this format:
rem echo    K-NAME-Description of this option
rem echo where "K" is a character used in CHOICE.EXE to select this option.
rem echo/
rem echo Review the extensive example at "Windows-DOS Commands Help" folder.
rem goto :EOF

rem GameLink.gr FFmpeg Mega Μενού Script
rem Creator and Modder Notes & Declaration of AGPL V3 Licence and minimum guide in Greeks
rem GameLink EL - 21-3-2024
rem              version 1.0
rem https://el.gamelink.gr/blog/Pws-Mporeite-Na-Mikrynete-ta-Video-gia-tis-MkDocs-Selides-sas-me-to-ffmpeg/ 
rem
rem Το gamelink.gr σας προσφέρει αυτό το αυτοματοποιημένο & πολύ χρήσιμο για το FFmpeg menu batch 
rem script που την αρχική του μορφή θα την βρείτε για κατέβασμα από το dostips.com [1ο Link] αφού 
rem τροποποιήθηκε κατάλληλα για να εκτελεί μια πλειάδα από scripts [βάλτε & άλλα μεχρι 9+26 = 35] που
rem εκτελούν το FFmpeg εκτελέσιμο [το οποίο δεν μου ανήκει] για ένα, περισσότερα ή όλα τα αρχεία 
rem βίντεο σε έναν φάκελο αλλά το ποιο σημαντικό να μιλάει ... Ελληνικά.
rem Ο ευκολότερος τρόπος χρήσης του αφού αποσυμπιέσετε τα αρχεία του gamelink.gr-ffmpeg-scripts.zip 
rem αρχείου στον φάκελο bin του FFmpeg φακέλου είναι να γράψετε vidmenu στην μπάρα Url του explorer 
rem στον φάκελο που έχετε τα βίντεο, να πλοηγηθείτε με τους αριθμούς και όταν σας ζητηθεί να γράψετε
rem το ή τα αρχεία βίντεο που θέλετε να μετατρέψετε γράφοντας το 1ο γράμμα & πατώντας το tab κουμπί
rem στο πληκτρολόγιο για να συμπληρώσει αυτόματα το όνομα του αρχείου, που αν έχει κενά προσθέτει ""
rem στο όνομα,κάτι που πρέπει να κάνετε & εσείς αν επικολλήσετε ονομασία αρχείου με κενά ή ειδικούς 
rem χαρακτήρες. Πολύ προσοχή στους ειδικούς χαρακτήρες.   
rem Για κάθε αρχείο θα πρέπει να υπάρχει τουλάχιστον ένα κενό [Πατάτε Spacebar για το επόμενο αρχείο]
rem και στο τέλος Enter για να αρχίσει η μετατροπή τους. Spacebar ή Enter ξεκολλάει απο παύση.
rem Το Url του gamelink.gr-FFmpeg-scripts.zip αλλά και το άρθρο θα το βρείτε στο 2o Url [2o Link]. 
rem Εκεί μπορείτε να το κατεβάσετε ξανά,να μάθετε πως να το χρησιμοποιείτε ή πως να προσθέσετε χειρο-
rem κίνητα το FFmpeg στα Windows. 
rem Επίσης αυτό το script χρησιμοποιεί UTF-8 codepage. Αν τα Windows 7, 8, 8.1, 10 & 11 δεν έχουν
rem ρυθμιστεί να τα χρησιμοποιούν,[control panel > region > administrative] ή το CMD δεν χρησιμοποιεί
rem UTF-8 true font οπως είναι τα Consolas ή τα Lucida consoles ως προκαθορισμένα font [γράφω πως να
REM το ρυθμίσετε στο άρθρο] το script θα κλείσει!
rem
rem Καλές Επεξεργασίες Βίντεο !
rem 
rem Η Άδεια χρήσης του είναι AGPLV3 και μπορείτε να διαβάσετε στα Ελληνικά εδώ: https://mathe.ellak.gr/gpl-3-0-txt/
rem Το FFmpeg ανήκει στους κατόχους του που μπορείτε να βρείτε εδώ: https://www.ffmpeg.org

(set \n=^
%=This is a GameLink.gr Star Wars Live SpaceStation=%
)

if not exist "ffmpeg.exe" goto FFmpeg
if not exist "ffprobe.exe" goto FFprobe 
if not exist "ffplay.exe" goto FFplay
if not exist "FFmpegScripts\" goto ERROR
if not exist "finalFFmpegScripts\" goto ERROR

:begin
set "title=%USERNAME%'s FFmpeg Scripts Μενού!\n!!\n!           Από το GameLink.gr"
set "header[0]="
set "spac=%title:~-7,-6%"
for /L %%i in (0,1,77) do if "!title:~%%i,1!" neq "" set "header[0]=!header[0]! !title:~%%i,1!"
for %%a in (A B C D E F G H I J K L M N O P Q R S T U V W X Y Z) do set "header[0]=!header[0]:%%a=%%a!" 
if !spac! equ L (set "textChoice=να πάει πίσω|έξοδο" ) else ( set "textChoice=πάει πίσω|έξοδο")
set "spaces=         "
set "action[.txt]=type"
set "action[.bat]=call"
color 1F
set "level=0"
call :nextLevel "FFmpegScripts\"
color
cls
goto :EOF

:nextLevel subFolder
rem Enter next subFolder level and get directories, .txt and .bat files
setlocal EnableDelayedExpansion
cd %1
for /F "delims==" %%a in ('set option[ 2^>NUL') do set "%%a="
if !spac! neq L goto begin
set "choices= 0"
set "maxLen=0"
set "spc= "
for /F "tokens=1,2* delims=-" %%a in ('dir /B *. *.txt *.bat') do (
   set "choices=!choices!%%a"
   set "option[%%a]=%%b"
   for /L %%i in (!maxLen!,1,40) do if "!option[%%a]:~%%i,1!" neq "" set "maxLen=%%i" & set "spc=!spc! "
   set "descrip[%%a]=%%c"
   if "!descrip[%%a]:~-4,1!" equ "." (set "type[%%a]= ") else set "type[%%a]= "
)
set /A maxLen+=2
for /F "tokens=2 delims=[]" %%a in ('set option[') do (
   set "show[%%a]=!option[%%a]!%spc%"
   set "show[%%a]= !show[%%a]:~0,%maxLen%!"
)

:thisLevel
rem Show menu options at this level
title !title! είναι στο (!arxiki!)
cls
echo/
for /L %%i in (0,1,%level%) do (
   set /A "spc=%%i*3"
   for %%n in ("!spc!") do echo    !spaces:~%%~n!!header[%%i]!& echo/
)
for /F "tokens=2 delims=[]" %%a in ('set option[') do (
   for %%b in ("!descrip[%%a]!") do echo !type[%%a]!  %%a-!show[%%a]! %%~Nb
)
echo/

rem Select option and activate it: open subfolder or: show .txt file / run .bat file
set /A "cho=^!level*8"
choice /N /C %choices% /M "Επέλεξε τι θες να κάνω πατώντας τον Αριθμό ή το Γράμμα (0 για !textChoice:~%cho%,12!):"
set "choice=!choices:~%errorlevel%,1!"
if %choice% == 0  exit /B
set "option=!option[%choice%]!"
set "lastTitle=%title%"
set "title=%title%  |>  %choice%-%option%" 
title !title!
set "descrip=!descrip[%choice%]!"
set /A "level+=1"
for %%a in ("%descrip%") do set "header[%level%]=%choice%- %option%  %%~Na"
if "%descrip:~-4,1%" neq "." (
   call :nextLevel "%choice%-%option%-%descrip%"
) else (

   rem If you want to preserve full menu on screen while a .bat or .txt run, cancel next IF:
   if CLEAR == CLEAR (
      cls
      for /L %%i in (0,1,%level%) do (
         set /A "spc=%%i*3"
         for %%n in ("!spc!") do echo/& echo    !spaces:~%%~n!!header[%%i]!
      )
   )

   echo/
   !action[%descrip:~-4%]! "%choice%-%option%-%descrip%"
   echo/
   pause
)
set /A "level-=1"
set "title=%lastTitle%"
goto thisLevel

:FFmpeg
call vidFFmpegerr.bat
exit /b 1

:FFprobe
call vidFFproberr.bat
exit /b 1

:FFplay
call vidFFplayerr.bat
exit /b 1

:ERROR
endlocal
call vidNoffmpegsrc.bat
exit /b 1
